<?php

//use Illuminate\Http\Request;
use App\Http\Controllers\DatabaseUtilityController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SettingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::middleware(['check.app.version'])->group(function () {
    Route::post('user/self/register', [UserController::class, 'userRegister']);
    Route::post('user/login', [UserController::class, 'userLogin']);
    Route::post('user/validate', [UserController::class, 'userValidate']);

    Route::post('basic/data', [SettingController::class, 'getBasicData']);

    Route::post('vehicle/category/all', [SettingController::class, 'vehicleCategoryAll']);
    Route::post('vehicle/all', [SettingController::class, 'vehicleAll']);

    Route::group(['middleware' => ['jwt.verify']], function () {
        Route::post('user/register', [UserController::class, 'userRegister']);
        Route::post('user/data', [UserController::class, 'userData']);
        Route::post('user/all', [UserController::class, 'userAll']);
        Route::post('user/manage', [UserController::class, 'userManage']);
        Route::post('user/password/change', [UserController::class, 'userPasswordChange']);
        Route::post('user/logout', [UserController::class, 'userLogout']);
    });
});
