<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Sales Order PDF</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            background-color: #ffffff;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 700px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #e0e0e0;
        }

        h2,
        h3 {
            margin: 0 0 10px;
            color: #333;
        }

        p {
            margin: 3px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .info-table td {
            vertical-align: top;
            padding: 5px 0;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .items-table th {
            background-color: #f2f2f2;
            font-weight: bold;
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .total-table td {
            padding: 5px;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 11px;
            color: #999;
        }
    </style>
</head>

<body>

    <div class="container">
        <h2>Thank You for your Business!</h2>
        @if(isset($company_name))
            <p><strong>{{ $company_name }}</strong></p>
            @if(isset($company_address))
                <p>{{ $company_address }}</p>
            @endif
            @if(isset($company_phone))
                <p>Phone: {{ $company_phone }}</p>
            @endif
        @endif

        <hr>

        <table class="info-table">
            <tr>
                <td>
                    @if(isset($sales_order_number))
                        <p><strong>Sales Order ID:</strong> {{ $sales_order_number }}</p>
                    @endif
                    @if(isset($order_date_time))
                        <p><strong>Order Date & Time:</strong> {{ $order_date_time }}</p>
                    @endif
                    @if(isset($payment_type))
                        <p><strong>Payment Type:</strong> {{ $payment_type }}
                            @if($payment_type == "Cheque" && isset($cheque_number))
                                ({{ $cheque_number }})
                            @endif
                        </p>
                    @endif
                    @if(isset($note))
                        <p><strong>Note:</strong> {{ $note }}</p>
                    @endif
                </td>
                <td class="text-right">
                    @if(isset($due_date_time))
                        <p><strong>Due Date:</strong> {{ $due_date_time }}</p>
                    @endif
                    @if(isset($se_name))
                        <p><strong>Sales Executive:</strong> {{ $se_name }}</p>
                    @endif
                </td>
            </tr>
        </table>

        <hr>

        <h3>Customer</h3>
        <table class="info-table">
            <tr>
                <td>
                    @if(isset($customer_name))
                        <p><strong>Name:</strong> {{ $customer_name }}</p>
                    @endif
                    @if(isset($customer_shipping_address))
                        <p><strong>Shipping Address:</strong> {{ $customer_shipping_address }}</p>
                    @endif
                </td>
                <td class="text-right">
                    @if(isset($customer_id))
                        <p><strong>ID:</strong> {{ $customer_id }}</p>
                    @endif
                    @if(isset($customer_vat_no))
                        <p><strong>VAT No:</strong> {{ $customer_vat_no }}</p>
                    @endif
                </td>
            </tr>
        </table>

        @if(isset($items) && count($items) > 0)
            <h3>Order Items @if(isset($ordered_item_count))({{ $ordered_item_count }})@endif</h3>
            <table class="items-table">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th class="text-center">QTY.</th>
                        <th class="text-right">Unit Price</th>
                        <th class="text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($items as $item)
                        <tr>
                            <td>
                                @if(isset($item['product_name']))
                                    <div><strong>{{ $item['product_name'] }}</strong></div>
                                @endif
                                @if(isset($item['product_number']))
                                    <div style="font-size: 11px;">SKU: {{ $item['product_number'] }}</div>
                                @endif
                                @if(isset($item['free_issues_count']) && $item['free_issues_count'] > 0)
                                    <div style="color: #007bff; font-size: 11px;">Free: {{ $item['free_issues_count'] }}</div>
                                @endif
                            </td>
                            <td class="text-center">{{ $item['qty'] ?? '—' }}</td>
                            <td class="text-right">{{ number_format($item['unit_price'], 2) ?? '0.00' }}</td>
                            <td class="text-right">{{ number_format($item['total'], 2) ?? '0.00' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <table class="total-table" style="margin-top: 15px;">
                @if(isset($sub_total))
                    <tr>
                        <td class="text-right"><strong>Subtotal:</strong></td>
                        <td class="text-right" width="100px">{{ number_format($sub_total, 2) }} LKR</td>
                    </tr>
                @endif
                @if(isset($discount))
                    <tr>
                        <td class="text-right"><strong>Discount:</strong></td>
                        <td class="text-right">{{ number_format($discount, 2) }} LKR</td>
                    </tr>
                @endif
                @if(isset($total_vat))
                    <tr>
                        <td class="text-right"><strong>VAT:</strong></td>
                        <td class="text-right">{{ number_format($total_vat, 2) }} LKR</td>
                    </tr>
                @endif
                @if(isset($total))
                    <tr>
                        <td class="text-right"><strong>Total:</strong></td>
                        <td class="text-right"><strong>{{ number_format($total, 2) }} LKR</strong></td>
                    </tr>
                @endif
            </table>
        @endif

        <div class="footer">
            © {{ date('Y') }} Idia Cooperation (Pvt) Ltd.
        </div>
    </div>

</body>

</html>