<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Delivery Note</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #222;
            margin: 20px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .header h2 {
            margin: 0;
        }

        .company-info {
            margin-bottom: 10px;
            font-size: 11px;
        }

        .section {
            margin-bottom: 15px;
        }

        table.meta,
        table.items,
        table.total {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        table.meta td,
        table.meta th,
        table.items td,
        table.items th,
        table.total td,
        table.total th {
            border: 1px solid #ddd;
            padding: 6px;
        }

        table.items th {
            background-color: #f2f2f2;
        }

        .footer {
            font-size: 11px;
            margin-top: 30px;
            color: #555;
        }

        .signatures td {
            padding-top: 40px;
            text-align: center;
        }

        .text-right {
            text-align: right;
        }
    </style>
</head>

<body>

    <!-- Header -->
    <div class="header">
        <h2>{{ $company_name ?? 'Company Name' }}</h2>
        <p class="company-info">
            {{ $company_address ?? 'Company Address' }} <br>
            Tel: {{ $company_phone ?? '+94 72200 2200' }}
        </p>
        <h3>DELIVERY NOTE</h3>
    </div>

    <!-- Customer and Meta Info -->
    <table class="meta">
        <tr>
            <td><strong>Customer:</strong></td>
            <td>{{ $customer_name ?? 'Customer' }}</td>
            <td><strong>Do No.:</strong></td>
            <td>{{ $delivery_note_number ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td><strong>Address:</strong></td>
            <td>{{ $customer_shipping_address ?? 'N/A' }}</td>
            <td><strong>Ref No.:</strong></td>
            <td>{{ $sales_order_number ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td><strong>Mobile:</strong></td>
            <td>{{ $customer_id ?? 'N/A' }}</td>
            <td><strong>Salesman:</strong></td>
            <td>{{ $salesman ?? $se_name ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td><strong>Date:</strong></td>
            <td>{{ $date ?? now()->format('Y-m-d') }}</td>
            <td colspan="2"></td>
        </tr>
    </table>

    <!-- Item Table -->
    <table class="items">
        <thead>
            <tr>
                <th>Item Description</th>
                <th>Qty</th>
            </tr>
        </thead>
        <tbody>
            @forelse($items ?? [] as $item)
                <tr>
                    <td>
                        {{ $item['product_name'] ?? 'Unnamed Item' }}
                        @if(!empty($item['product_number']))
                            <br><small>SKU: {{ $item['product_number'] }}</small>
                        @endif
                    </td>
                    <td class="text-right">{{ $item['qty'] ?? 0 }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="2">No items found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Total -->
    <!-- <table class="total">
        <tr>
            <td><strong>Grand Total:</strong></td>
            <td class="text-right"><strong>{{ number_format($total ?? 0, 2) }} LKR</strong></td>
        </tr>
    </table> -->

    <!-- Footer Note -->
    <div class="footer">
        Every effort is made to ensure all orders are completed accurately. If there are any discrepancies,
        please inform us before using the items. <br>
        <strong>Idea Industries Limited</strong> will not be responsible for losses due to non-conformity.
        <br><br>
        Printed on {{ now()->format('d/m/Y') }} at {{ now()->format('h:i A') }}
    </div>

    <!-- Signatures -->
    <table class="signatures" width="100%">
        <tr>
            <td>Prepared By</td>
            <td>Authorized By</td>
            <td>Customer Signature</td>
        </tr>
    </table>

</body>

</html>