<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Welcome to i-Note</title>
    <style>
        body {
            font-family: "Arial", sans-serif;
            background-color: #f4f4f7;
            margin: 0;
            padding: 0;
        }

        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 10px;
            padding: 40px 30px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
            border: 1px solid #ccc;
            text-align: center;
        }

        .logo img {
            height: 60px;
            margin-bottom: 30px;
        }

        .title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .gradient-text {
            background: linear-gradient(to right, #7901f8, #f901b5);

            background-clip: text;

            -webkit-background-clip: text;

            -webkit-text-fill-color: transparent;

            color: #7901f8;
        }

        .message {
            font-size: 14px;
            color: #707070;
            margin-top: 10px;
            margin-bottom: 30px;
            font-weight: 300;
        }

        .btn {
            display: inline-block;
            background-color: #1e1e2f;
            color: #fff;
            padding: 14px 32px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
            margin-bottom: 30px;
            min-width: 240px;
        }

        .credentials {
            font-size: 14px;
            color: #333;
            margin-bottom: 30px;
        }

        .credentials strong {
            display: inline-block;
            width: 80px;
            text-align: right;
            margin-right: 8px;
        }

        .security {
            font-size: 14px;
            color: #707070;
            text-align: center;
            margin-top: 20px;
            border-top: 1px solid #eee;
            padding-top: 20px;
            font-weight: 300;
        }

        .security .reminder {
            font-weight: 700;
            margin-bottom: 6px;
            color: #2a2a2a;
        }

        .footer {
            font-size: 14px;
            color: #707070;
            /* updated color */
            margin-top: 40px;
            text-align: center;
            line-height: 1.6;
        }

        .footer a {
            text-decoration: none;
            color: #707070;
        }

        .footer strong {
            color: #2a2a2a;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="logo">
            <img src="http://img.mailinblue.com/6329647/images/6824449a5ab68_1747207322.png" alt="iNote Logo" />
        </div>
        <div class="title">
            Welcome to <span class="gradient-text">i-Note</span>
        </div>
        <div class="message">
            Hi {{$username}}, Welcome to iNote!<br />
            Your account has been successfully created. Login to your account with
            the credentials listed below.
        </div>

        <a href="[LOGIN_URL]" class="btn">Login to Your Account</a>

        <div class="credentials">
            <div><strong>Email:</strong> {{ $email }}</div>
            <div><strong>Password:</strong> {{ $temp_password}} </div>
        </div>

        <div class="security">
            <div class="reminder">⚠️ Security Reminder:</div>
            <div>
                For your protection, we recommend logging in immediately and updating
                your password.<br />
                You can change your password after logging in via the “Account
                Settings” section.
            </div>
        </div>
    </div>
    <div class="footer">
        <strong>Support</strong><br />
        If you experience any issues accessing your account, don’t hesitate to
        reach out to<br />
        <a href="mailto:support@iNote.com">support@iNote.com</a> or
        reply to this email.<br /><br />
        &copy; 2025 Idia Co-soperation (pvt) Ltd.
    </div>
</body>

</html>