<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Invoice Email</title>
</head>

<body style="margin: 0; padding: 0; background-color: #f3f4f6; font-family: Arial, sans-serif;">
    <table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#f3f4f6">
        <tr>
            <td align="center" style="padding: 30px 10px">
                <table width="100%" cellpadding="0" cellspacing="0" border="0"
                    style="max-width: 624px; background-color: #ffffff; border-radius: 12px; overflow: hidden;">
                    <!-- Header -->
                    <tr>
                        <td align="center" style="padding: 40px 20px 10px">
                            <h2 style="margin: 0; font-size: 24px; color: #2a2a2a">
                                Thank You for your Business!
                            </h2>
                            <p style="margin: 20px 0 0; font-size: 14px; color: #707070; font-weight: 300;">
                                {{ $company_name }}<br />
                                {{ $company_address }}<br />
                                Phone: {{ $company_phone }}
                            </p>
                        </td>
                    </tr>

                    <!-- Invoice and Customer Info -->
                    <tr>
                        <td style="padding: 20px 30px 0; font-size: 14px; color: #333">
                            <table width="100%" cellpadding="0" cellspacing="0"
                                style="background-color: #f6f8fa; padding: 10px; border-radius: 8px;">
                                <tr>
                                    <td style="vertical-align: top">
                                        <strong style="color: #707070; font-size: 12px; font-weight: 400;">Invoice
                                            No:</strong><br />
                                        <p style="color: #2a2a2a; font-size: 12px; font-weight: 600;">
                                            <span>INV-{{$invoice_no}}</span>
                                        </p>
                                    </td>
                                    <td align="right" style="vertical-align: top">
                                        <strong style="color: #707070; font-size: 12px; font-weight: 400;">Customer
                                            Name:</strong><br />
                                        <p style="color: #2a2a2a; font-size: 12px; font-weight: 600;">
                                            {{ $customer_name }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding-top: 10px">
                                        <strong style="color: #707070; font-size: 12px; font-weight: 400;">Order Date &
                                            Time:</strong><br />
                                        <p style="color: #2a2a2a; font-size: 12px; font-weight: 600;">
                                            {{ $order_date_time }}
                                        </p>
                                    </td>
                                    <td align="right" style="padding-top: 10px">
                                        <strong style="color: #707070; font-size: 12px; font-weight: 400;">Customer
                                            Contact:</strong><br />
                                        <p style="color: #2a2a2a; font-size: 12px; font-weight: 600;">
                                            {{ $customer_contact }}
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Warranty Table -->
                    <tr>
                        <td style="padding: 20px 30px 0">
                            <p style="margin: 0 0 8px; font-size: 12px; font-weight: 400; color: #707070;">
                                Warranty Note ({{ count($items) }}):
                            </p>
                            <table width="100%" cellpadding="10" cellspacing="0"
                                style="border-collapse: collapse; font-size: 12px; color: #707070;">
                                <thead>
                                    <tr style="background-color: #f6f8fa">
                                        <th align="left"
                                            style="border-top-left-radius: 8px; padding: 20px 0 20px 10px; border-bottom: 1px solid #ebedf0; font-weight: 400;">
                                            Item Name</th>
                                        <th align="center"
                                            style="border-bottom: 1px solid #ebedf0; padding: 10px; font-weight: 400;">
                                            QTY.</th>
                                        <th align="right"
                                            style="border-bottom: 1px solid #ebedf0; padding: 10px; font-weight: 400;">
                                            Period</th>
                                        <th align="right"
                                            style="border-bottom: 1px solid #ebedf0; padding: 10px; font-weight: 400;">
                                            Start Date</th>
                                        <th align="right"
                                            style="border-top-right-radius: 8px; padding: 10px; border-bottom: 1px solid #ebedf0; font-weight: 400;">
                                            End Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $index => $item)
                                        <tr>
                                            <td
                                                style="border: 1px solid #ebedf0; border-top: none; padding: 10px; font-size: 12px; font-weight: 400; color: #2a2a2a;">
                                                {{ $item['product_name'] }}<br />
                                                <small style="color: #707070">SKU: {{ $item['product_number'] }}</small>
                                            </td>
                                            <td align="center"
                                                style="border: 1px solid #ebedf0; border-top: none; padding: 10px; font-size: 12px; font-weight: 400; color: #707070;">
                                                {{ $item['qty'] }}
                                            </td>
                                            <td align="right"
                                                style="border: 1px solid #ebedf0; border-top: none; padding: 10px; font-size: 12px; font-weight: 400; color: #707070;">
                                                {{ $item['warranty_period'] }}
                                            </td>
                                            <td align="right"
                                                style="border: 1px solid #ebedf0; border-top: none; padding: 10px; font-size: 12px; font-weight: 400; color: #707070;">
                                                {{ $item['warranty_start_date'] }}
                                            </td>
                                            <td align="right"
                                                style="border: 1px solid #ebedf0; border-top: none; padding: 10px; font-size: 12px; font-weight: 400; color: #707070;">
                                                {{ $item['warranty_end_date'] }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </td>
                    </tr>

                    <!-- Total Row -->
                    <tr>
                        <td colspan="5" style="padding: 20px 30px">
                            <table width="100%" cellpadding="9" cellspacing="0"
                                style="background-color: #f7f8fa; border-radius: 8px; font-size: 12px; color: #707070;">
                                <tr>
                                    <td align="right" style="padding-right: 20px; font-weight: 400">Total QTY</td>
                                    <td align="right" style="font-weight: 400">{{ $total_qty }}</td>
                                </tr>
                                <tr>
                                    <td align="right" style="padding-right: 20px">Total Amount</td>
                                    <td align="right" style="font-weight: 400">{{ number_format($total, 2) }} LKR
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <!-- Support Section -->
        <tr>
            <td align="center" style="padding: 5px 20px 10px">
                <p style="font-size: 14px; color: #2a2a2a; font-weight: 700">Support</p>
                <p style="max-width: 500px; margin: 10px auto 0; font-size: 12px; color: #707070; font-weight: 300;">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore
                    et dolore magna aliqua.
                </p>
            </td>
        </tr>

        <!-- Footer -->
        <tr>
            <td align="center" style="padding: 20px; font-size: 12px; color: #707070; font-weight: 300;">
                ©️ 2025 Idia Cooperation (pvt) Ltd.
            </td>
        </tr>
    </table>
</body>

</html>