<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Sales Order</title>
    <style>
        /* Fallback styles for email clients */
        body,
        table,
        td,
        p,
        h1,
        h2,
        h3 {
            font-family: Arial, sans-serif !important;
        }

        .email-container {
            width: 100% !important;
            max-width: 600px !important;
            margin: 0 auto !important;
        }

        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
            }

            .mobile-padding {
                padding: 10px !important;
            }
        }
    </style>
</head>

<body style="margin: 0; padding: 0; background-color: #e8e8e8; font-family: Arial, sans-serif;">

    <!-- Main Container -->
    <table cellpadding="0" cellspacing="0" border="0" width="100%" style="background-color: #e8e8e8; padding: 40px 0;">
        <tr>
            <td align="center">

                <!-- Email Content Container -->
                <table cellpadding="0" cellspacing="0" border="0" width="600" class="email-container"
                    style="background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">

                    <!-- Header Section -->
                    <tr>
                        <td style="padding: 30px 30px 25px 30px; text-align: center;">
                            <h2 style="margin: 0 0 15px 0; font-size: 22px; color: #333333; font-weight: 600;">Thank You
                                for your Business!</h2>
                            @if(isset($company_name))
                                <p style="margin: 0 0 5px 0; font-size: 13px; color: #666666; line-height: 1.4;">
                                    {{ $company_name }}</p>
                                @if(isset($company_address))
                                    <p style="margin: 0 0 5px 0; font-size: 13px; color: #666666; line-height: 1.4;">
                                        {{ $company_address }}</p>
                                @endif
                                @if(isset($company_phone))
                                    <p style="margin: 0; font-size: 13px; color: #666666; line-height: 1.4;">Phone:
                                        {{ $company_phone }}</p>
                                @endif
                            @endif
                        </td>
                    </tr>

                    <!-- Details Section -->
                    <tr>
                        <td style="padding: 0 30px 25px 30px;">
                            <table cellpadding="0" cellspacing="0" border="0" width="100%"
                                style="background-color: #f8f9fa; border-radius: 6px; padding: 15px;">
                                <tr>
                                    <td width="50%" style="vertical-align: top; padding-right: 10px;">
                                        @if(isset($sales_order_id))
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"><strong>Sales Order ID:</strong></p>
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"> {{ $sales_order_number }}</p>
                                        @endif
                                        @if(isset($order_date_time))
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"><strong>Order Date & Time:</strong></p>
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"> {{ $order_date_time }}</p>
                                        @endif
                                        @if(isset($payment_type))
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;">
                                                <strong>Payment Type:</strong>
                                            </p>
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;">
                                                {{ $payment_type }}
                                                @if($payment_type == "Cheque")
                                                    ({{ $cheque_number }})
                                                @endif
                                            </p>
                                        @endif

                                        @if(isset($note))
                                            <p style="margin: 0; font-size: 13px; color: #333333;"><strong>Note:</strong></p>
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"> {{ $note }}</p>
                                        @endif
                                    </td>
                                    <td width="50%" style="vertical-align: top; text-align: right; padding-left: 10px;">
                                        @if(isset($due_date_time))
                                            <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"><strong>Due
                                                    Date:</strong></p>
                                              <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"> {{ $due_date_time }}</p>
                                        @endif
                                        <!-- @if(isset($se_name))
                                            <p style="margin: 0; font-size: 13px; color: #333333;"><strong>Sales
                                                    Executive:</strong></p>
                                             <p style="margin: 0 0 8px 0; font-size: 13px; color: #333333;"> {{ $se_name }}</p>
                                        @endif -->
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Customer Section -->
                    <tr>
                        <td style="padding: 0 30px 25px 30px;">
                            <table cellpadding="0" cellspacing="0" border="0" width="100%"
                                style="background-color: #f8f9fa; border-radius: 6px; padding: 15px;">
                                <tr>
                                    <td colspan="2">
                                        <h3
                                            style="margin: 0 0 15px 0; font-size: 14px; color: #333333; font-weight: 600;">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M2.60938 7.04883V10.208C2.60938 11.9953 2.60938 12.8884 3.1639 13.4435C3.71968 13.9993 4.6121 13.9993 6.39883 13.9993H10.1883C11.9744 13.9993 12.8674 13.9993 13.4226 13.4435C13.9777 12.8884 13.9777 11.9947 13.9777 10.208V7.04883" stroke="#2A2A2A" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M10.1897 11.1533C9.75766 11.5366 9.06988 11.7848 8.29494 11.7848C7.51999 11.7848 6.83221 11.5366 6.40021 11.1533M7.11831 5.7375C6.94021 6.38108 6.29221 7.49076 5.0619 7.65118C3.97559 7.79328 3.15076 7.31897 2.94044 7.12065C2.70865 6.9596 2.17939 6.44487 2.04992 6.12403C1.92045 5.80192 2.07139 5.1053 2.17939 4.82109L2.61076 3.57183C2.71623 3.25794 2.96318 2.51584 3.21581 2.26447C3.46844 2.01311 3.98001 2.00237 4.19096 2.00237H8.61578C9.75451 2.01879 12.2448 1.99226 12.7368 2.00237C13.2294 2.01247 13.525 2.42552 13.6115 2.60237C14.3461 4.38088 14.6315 5.40024 14.6315 5.8335C14.5355 6.29708 14.1389 7.16992 12.7368 7.55455C11.2798 7.9537 10.4537 7.17686 10.1947 6.87876M6.51895 6.87876C6.72421 7.13076 7.36778 7.63791 8.29999 7.65054C9.23282 7.66318 10.0381 7.01265 10.3242 6.68613C10.405 6.5895 10.58 6.3034 10.7619 5.73687" stroke="#2A2A2A" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                            Customer
                                        </h3>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="50%" style="vertical-align: top; padding-right: 10px;">
                                        @if(isset($customer_name))
                                            <p
                                                style="margin: 0 0 3px 0; font-size: 13px; color: #333333; font-weight: 600;">
                                                Customer Name:</p>
                                            <p style="margin: 0 0 12px 0; font-size: 13px; color: #555555;">
                                                {{ $customer_name }}</p>
                                        @endif
                                        @if(isset($customer_shipping_address))
                                            <p
                                                style="margin: 0 0 3px 0; font-size: 13px; color: #333333; font-weight: 600;">
                                                Shipping Address:</p>
                                            <p style="margin: 0; font-size: 13px; color: #555555;">
                                                {{ $customer_shipping_address }}</p>
                                        @endif
                                    </td>
                                    <td width="50%" style="vertical-align: top; text-align: right; padding-left: 10px;">
                                        @if(isset($customer_id))
                                            <p
                                                style="margin: 0 0 3px 0; font-size: 13px; color: #333333; font-weight: 600;">
                                                Customer ID:</p>
                                            <p style="margin: 0 0 12px 0; font-size: 13px; color: #555555;">
                                                {{ $customer_id }}</p>
                                        @endif
                                        @if(isset($customer_vat_no))
                                            <p
                                                style="margin: 0 0 3px 0; font-size: 13px; color: #333333; font-weight: 600;">
                                                Customer VAT No:</p>
                                            <p style="margin: 0; font-size: 13px; color: #555555;">{{ $customer_vat_no }}
                                            </p>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Items Section -->
                    @if(isset($items) && count($items) > 0)
                        <tr>
                            <td style="padding: 0 30px 30px 30px;">
                                <h3 style="margin: 0 0 15px 0; font-size: 14px; color: #333333; font-weight: 600;">Order
                                    Items @if(isset($ordered_item_count))({{ $ordered_item_count }})@endif</h3>

                                <!-- Items Table -->
                                <table cellpadding="0" cellspacing="0" border="0" width="100%"
                                    style="border-collapse: collapse;">
                                    <!-- Table Header -->
                                    <tr style="background-color: #f8f9fa;">
                                        <td
                                            style="padding: 12px 8px; font-size: 13px; font-weight: 600; color: #333333; border-bottom: 1px solid #e9ecef;">
                                            Item</td>
                                        <td
                                            style="padding: 12px 8px; font-size: 13px; font-weight: 600; color: #333333; border-bottom: 1px solid #e9ecef; text-align: center;">
                                            QTY.</td>
                                        <td
                                            style="padding: 12px 8px; font-size: 13px; font-weight: 600; color: #333333; border-bottom: 1px solid #e9ecef; text-align: right;">
                                            Unit Price</td>
                                        <td
                                            style="padding: 12px 8px; font-size: 13px; font-weight: 600; color: #333333; border-bottom: 1px solid #e9ecef; text-align: right;">
                                            Total</td>
                                    </tr>

                                    <!-- Item Rows -->
                                    @foreach($items as $item)
                                        <tr>
                                            <td
                                                style="padding: 12px 8px; font-size: 13px; color: #555555; border-bottom: 1px solid #f0f0f0; vertical-align: top;">
                                                @if(isset($item['product_name']))
                                                    <div style="font-weight: 500; color: #333333; margin-bottom: 3px;">
                                                        {{ $item['product_name'] }}</div>
                                                @endif
                                                @if(isset($item['product_number']))
                                                    <div style="font-size: 12px; color: #666666; margin-bottom: 3px;">SKU:
                                                        {{ $item['product_number'] }}</div>
                                                @endif
                                                @if(isset($item['free_issues_count']) && $item['free_issues_count'] > 0)
                                                    <div style="color: #007bff; font-size: 12px; font-weight: 500;">You have
                                                        {{ $item['free_issues_count'] }} free issues.</div>
                                                @endif
                                            </td>
                                            <td
                                                style="padding: 12px 8px; font-size: 13px; color: #555555; border-bottom: 1px solid #f0f0f0; text-align: center;">
                                                @if(isset($item['qty'])){{ $item['qty'] }}@endif</td>
                                            <td
                                                style="padding: 12px 8px; font-size: 13px; color: #555555; border-bottom: 1px solid #f0f0f0; text-align: right;">
                                                @if(isset($item['unit_price'])){{ number_format($item['unit_price'], 2) }}@endif
                                            </td>
                                            <td
                                                style="padding: 12px 8px; font-size: 13px; color: #555555; border-bottom: 1px solid #f0f0f0; text-align: right;">
                                                @if(isset($item['total'])){{ number_format($item['total'], 2) }}@endif</td>
                                        </tr>
                                    @endforeach
                                </table>

                                <!-- Totals Section -->
                                <table cellpadding="0" cellspacing="0" border="0" width="100%"
                                    style="margin-top: 20px; border-top: 1px solid #e9ecef; padding-top: 15px;">
                                    @if(isset($sub_total))
                                        <tr>
                                            <td style="padding: 3px 0; text-align: right; font-size: 13px; color: #555555;">
                                                Subtotal:</td>
                                            <td
                                                style="padding: 3px 0 3px 20px; text-align: right; font-size: 13px; color: #555555; width: 100px;">
                                                {{ number_format($sub_total, 2) }} LKR</td>
                                        </tr>
                                    @endif
                                    @if(isset($discount))
                                        <tr>
                                            <td style="padding: 3px 0; text-align: right; font-size: 13px; color: #555555;">
                                                Discount:</td>
                                            <td
                                                style="padding: 3px 0 3px 20px; text-align: right; font-size: 13px; color: #555555;">
                                                {{ number_format($discount, 2) }} LKR</td>
                                        </tr>
                                    @endif
                                    @if(isset($total_vat))
                                        <tr>
                                            <td style="padding: 3px 0; text-align: right; font-size: 13px; color: #555555;">VAT:
                                            </td>
                                            <td
                                                style="padding: 3px 0 3px 20px; text-align: right; font-size: 13px; color: #555555;">
                                                {{ number_format($total_vat, 2) }} LKR</td>
                                        </tr>
                                    @endif
                                    @if(isset($total))
                                        <tr style="border-top: 1px solid #e9ecef;">
                                            <td
                                                style="padding: 8px 0 3px 0; text-align: right; font-size: 14px; color: #333333; font-weight: 600;">
                                                Total:</td>
                                            <td
                                                style="padding: 8px 0 3px 20px; text-align: right; font-size: 14px; color: #333333; font-weight: 600;">
                                                {{ number_format($total, 2) }} LKR</td>
                                        </tr>
                                    @endif
                                </table>
                            </td>
                        </tr>
                    @endif

                </table>

                <!-- Support Section -->
                <!-- <table cellpadding="0" cellspacing="0" border="0" width="600" class="email-container"
                    style="margin-top: 30px; background-color: #e8e8e8; ">
                    <tr>
                        <td style="padding: 25px; text-align: center;">
                            <h3 style="margin: 0 0 12px 0; font-size: 16px; color: #333333; font-weight: 600;">Support
                            </h3>
                            <p style="margin: 0; font-size: 13px; color: #666666; line-height: 1.6;">
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                incididunt ut
                                labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation
                                ullamco laboris
                                nisi ut aliquip ex ea commodo consequat.
                            </p>
                        </td>
                    </tr>
                </table> -->

                <!-- Footer -->
                <table cellpadding="0" cellspacing="0" border="0" width="600" class="email-container"
                    style="margin-top: 10px; background-color: #e8e8e8; ">
                    <tr>
                        <td style="padding: 15px; text-align: center; font-size: 11px; color: #999999;">
                            ©️ {{ date('Y') }} Idia Cooperation (pvt) Ltd.
                        </td>
                    </tr>
                </table>

            </td>
        </tr>
    </table>

</body>

</html>