<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Delivery Note</title>
    <style>
        body,
        table,
        td,
        p,
        h1,
        h2,
        h3 {
            font-family: Arial, sans-serif !important;
        }

        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .section {
            padding: 20px 30px;
        }

        .header-title {
            font-size: 22px;
            font-weight: 600;
            color: #333333;
            text-align: center;
            margin-bottom: 5px;
        }

        .sub-info {
            font-size: 13px;
            color: #666;
            text-align: center;
            margin-bottom: 15px;
        }

        .table th,
        .table td {
            font-size: 13px;
            padding: 8px;
            border-bottom: 1px solid #e9ecef;
        }

        .footer {
            font-size: 12px;
            color: #777;
            text-align: center;
            padding: 20px 30px;
            background-color: #f8f9fa;
        }
    </style>
</head>

<body style="margin: 0; padding: 40px 0; background-color: #e8e8e8;">

    <table width="100%" cellpadding="0" cellspacing="0">
        <tr>
            <td align="center">
                <table class="email-container" cellpadding="0" cellspacing="0">

                    <!-- Header -->
                    <tr>
                        <td class="section">
                            <div class="header-title">DELIVERY NOTE</div>
                            <div class="sub-info">
                                {{ $company_name ?? 'Company Name' }}<br />
                                {{ $company_address ?? 'Company Address' }}<br />
                                Phone: {{ $company_phone ?? '+94 72200 2200' }}
                            </div>
                        </td>
                    </tr>

                    <!-- Delivery Info -->
                    <tr>
                        <td class="section" style="background-color: #f8f9fa;">
                            <table width="100%">
                                <tr>
                                    <td width="50%">
                                        <p style="margin: 0 0 5px;"><strong>Customer:</strong>
                                            {{ $customer_name ?? 'Customer' }}</p>
                                        <p style="margin: 0 0 5px;"><strong>Address:</strong>
                                            {{ $customer_shipping_address ?? 'N/A' }}</p>
                                        <p style="margin: 0;"><strong>Mobile No:</strong> {{ $customer_id ?? 'N/A' }}
                                        </p>
                                    </td>
                                    <td width="50%" style="text-align: right;">
                                        <p style="margin: 0 0 5px;"><strong>Do No.:</strong>
                                            {{ $delivery_note_number ?? 'N/A' }}</p>
                                        <p style="margin: 0 0 5px;"><strong>Ref No.:</strong>
                                            {{ $sales_order_number ?? 'N/A' }}</p>
                                        <p style="margin: 0 0 5px;"><strong>Salesman:</strong>
                                            {{ $salesman ?? $se_name ?? 'N/A' }}</p>
                                        <p style="margin: 0;"><strong>Date:</strong>
                                            {{ $date ?? now()->format('Y-m-d') }}</p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Items -->
                    @if(isset($items) && count($items) > 0)
                        <tr>
                            <td class="section">
                                <table width="100%" cellpadding="0" cellspacing="0" class="table">
                                    <tr style="background-color: #f1f1f1;">
                                        <th align="left">Item</th>
                                        <th align="center">QTY</th>
                                    </tr>
                                    @foreach($items as $item)
                                        <tr>
                                            <td>
                                                {{ $item['product_name'] ?? 'Unnamed Product' }}
                                                @if(isset($item['product_number']))
                                                    <br /><small>SKU: {{ $item['product_number'] }}</small>
                                                @endif
                                            </td>
                                            <td align="center">{{ $item['qty'] ?? '0' }}</td>
                                        </tr>
                                    @endforeach
                                </table>
                            </td>
                        </tr>
                    @endif

                    <!-- Totals -->
                    <!-- <tr>
                        <td class="section" style="text-align: right;">
                            <p><strong>Grand Total:</strong> {{ number_format($total ?? 0, 2) }} LKR</p>
                        </td>
                    </tr> -->

                    <!-- Footer Notice -->
                    <tr>
                        <td class="footer">
                            Every effort is made to ensure the accuracy of your delivery. If there are any
                            discrepancies,
                            please notify us before use. <br />
                            <strong>Idea Industries Limited</strong> will not be held liable for any inconvenience
                            caused by
                            non-conformity.
                            <br /><br />
                            <em>Printed on {{ now()->format('d/m/Y') }} at {{ now()->format('h:i A') }}</em>
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>

</body>

</html>