<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Password Reset Confirmation</title>
    <style>
        body {
            background-color: #f4f4f7;
            font-family: Arial, sans-serif;
            padding: 0;
            margin: 0;
        }

        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 10px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.04);
            border: 1px solid #ccc;
        }

        .icon img {
            height: 50px;
            margin-bottom: 20px;
        }

        .title {
            font-size: 22px;
            font-weight: bold;
            color: #2a2a2a;
            margin-bottom: 10px;
        }

        .title span {
            background: linear-gradient(to right, #7901f8, #f901b5);
            background-clip: text;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            color: #7901f8;
        }

        .subtitle {
            font-size: 14px;
            color: #707070;
            margin-bottom: 30px;
            font-weight: 300;
        }

        .security-warning {
            text-align: center;
            margin-top: 10px;
            font-size: 14px;
            color: #2a2a2a;
        }

        .security-warning strong {
            display: block;
            margin: 10px 0 6px;
        }

        .security-warning p {
            color: #707070;
            font-weight: 300;
            margin: 0 auto;
            max-width: 440px;
            line-height: 1.6;
        }

        .footer {
            font-size: 14px;
            color: #707070;
            text-align: center;
            margin-top: 40px;
            line-height: 1.6;
        }

        .footer a {
            color: #707070;
            text-decoration: none;
        }

        .footer strong {
            color: #2a2a2a;
        }

        .copyright {
            font-size: 13px;
            color: #707070;
            margin-top: 16px;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="icon">
            <img src="https://cdn-icons-png.flaticon.com/512/3064/3064197.png" alt="Lock Icon" />
        </div>

        <div class="title">Your <span>I-Note</span> Password Has Been Reset</div>

        <div class="subtitle">
            This is a confirmation that your password has been successfully reset.
        </div>

        <div class="security-warning">
            <strong>⚠️ Didn’t do this?</strong>
            <p>
                If you requested this reset, no further action is needed — you can ignore this email.<br /><br />
                However, if you did <strong>not</strong> request a password reset, please contact us immediately to
                secure your account.
            </p>
        </div>
    </div>

    <div class="footer">
        <strong>Support</strong><br />
        If you experience any issues accessing your account, feel free to reach out to<br />
        <a href="mailto:support@inote.com">support@iNote.com</a> or reply to this email.
        <div class="copyright">&copy; 2025 Idia Co-operation (Pvt) Ltd.</div>
    </div>
</body>

</html>