<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <title>OTP Email</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f7;
      margin: 0;
      padding: 0;
    }

    .email-container {
      max-width: 600px;
      margin: 40px auto;
      background-color: #ffffff;
      border-radius: 10px;
      padding: 40px 30px;
      text-align: center;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.04);
      border: 1px solid #ccc;
    }

    .icon {
      font-size: 40px;
      margin-bottom: 20px;
    }

    .icon img {
      height: 50px;
    }

    .title {
      font-size: 22px;
      font-weight: bold;
      color: #2a2a2a;
      margin-bottom: 10px;
    }

    .subtitle {
      font-size: 14px;
      color: #707070;
      margin-bottom: 30px;
      font-weight: 300;
    }

    .otp-box {
      display: inline-block;
      background-color: #f0f0f5;
      color: #2a2a2a;
      font-size: 24px;
      font-weight: bold;
      padding: 14px 24px;
      border-radius: 8px;
      letter-spacing: 8px;
      margin-bottom: 30px;
    }

    .info-text {
      font-size: 14px;
      color: #707070;
      text-align: left;
      line-height: 1.6;
      margin: 0 auto;
      max-width: 440px;
      font-weight: 300;
    }

    .info-text li {
      margin-bottom: 12px;
    }

    .footer {
      font-size: 14px;
      color: #707070;
      margin-top: 40px;
      text-align: center;
      line-height: 1.6;
    }

    .footer a {
      color: #707070;
      text-decoration: none;
    }

    .footer strong {
      color: #2a2a2a;
    }
  </style>
</head>

<body>
  <div class="email-container">
    <div class="icon">
      <img src="https://cdn-icons-png.flaticon.com/512/3064/3064197.png" alt="Lock Icon" />
    </div>
    <div class="title">Your One-Time Password (OTP)</div>
    <div class="subtitle">
      We received a request to verify your identity. Please use the One-Time
      Password (OTP) below to proceed
    </div>
    <div class="otp-box">{{ $otp }}</div>
    <ul class="info-text">
      <li>
        This code is valid for the next 10 minutes. For your security, do not
        share this code with anyone.
      </li>
      <li>
        If you did not initiate this request, please disregard this email. No
        further action is required on your part.
      </li>
    </ul>
  </div>

  <div class="footer">
    <strong>Support</strong><br />
    If you experience any issues accessing your account, don’t hesitate to
    reach out to<br />
    <a href="mailto:support@iNote.com">support@iNote.com</a> or
    reply to this email.<br /><br />
    &copy; 2025 Idia Co-operation (pvt) Ltd.
  </div>
</body>

</html>