CREATE TABLE
  `accounts` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `account_type_id` int DEFAULT NULL,
    `currency_type_id` int DEFAULT NULL,
    `account_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `account_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `balance` double (12, 2) DEFAULT '0.00',
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `account_types`
--
CREATE TABLE
  `account_types` (
    `id` bigint NOT NULL,
    `account_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE
  `expense_categories` (
    `id` bigint NOT NULL AUTO_INCREMENT,
    `category_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `company_id` int DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE
  `expenses` (
    `id` bigint NOT NULL AUTO_INCREMENT,
    `category_id` int DEFAULT NULL,
    `expense` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `company_id` int DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
--
-- Dumping data for table `account_types`
--
INSERT INTO
  `account_types` (
    `id`,
    `account_type`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'Current Account',
    1,
    '2025-03-20 00:56:26',
    'EMP-0001',
    '2025-03-19 13:56:47',
    'EMP-0001'
  ),
  (
    2,
    'Saving Account',
    1,
    '2025-03-20 00:56:26',
    'EMP-0001',
    '2025-03-19 13:57:00',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `areas`
--
CREATE TABLE
  `areas` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `province_id` int DEFAULT NULL,
    `area` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `areas`
--
INSERT INTO
  `areas` (
    `id`,
    `company_id`,
    `province_id`,
    `area`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    1,
    'Y',
    0,
    '2025-03-25 07:00:43',
    'EMP-0001',
    '2025-03-25 05:30:48',
    'EMP-0001'
  ),
  (
    2,
    1,
    1,
    'Kadawatha',
    1,
    '2025-03-26 19:05:05',
    'EMP-0001',
    '2025-03-26 13:35:05',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `batches`
--
CREATE TABLE
  `batches` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `batch_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `shift_id` int DEFAULT '1',
    `rm_batch_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `machine_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `product_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `qa_emp_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `op_emp_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `helper_emp_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `packager_emp_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `categories`
--
CREATE TABLE
  `categories` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

CREATE TABLE
  `supplier_categories` (
    `id` bigint NOT NULL AUTO_INCREMENT,
    `company_id` int DEFAULT NULL,
    `supplier_category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`)
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

INSERT INTO
  `categories` (
    `id`,
    `company_id`,
    `category`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    'Test',
    0,
    '2025-03-25 06:56:03',
    'EMP-0001',
    '2025-03-25 05:26:09',
    'EMP-0001'
  ),
  (
    2,
    1,
    'iPanel Lite 30cm B',
    1,
    '2025-03-26 19:12:33',
    'EMP-0001',
    '2025-03-26 13:42:33',
    'EMP-0001'
  ),
  (
    3,
    1,
    'iPanel Heavy 20cm B Grove ',
    1,
    '2025-03-26 19:13:12',
    'EMP-0001',
    '2025-03-26 13:43:12',
    'EMP-0001'
  ),
  (
    4,
    1,
    'iPanel Heavy 20cm Flat',
    1,
    '2025-03-26 19:13:29',
    'EMP-0001',
    '2025-03-26 13:43:29',
    'EMP-0001'
  ),
  (
    5,
    1,
    'iPanel Finishing 10cm 2x2',
    1,
    '2025-03-26 19:14:03',
    'EMP-0001',
    '2025-03-26 13:44:03',
    'EMP-0001'
  ),
  (
    6,
    1,
    'iPanel Finishing 10cm 3x1',
    1,
    '2025-03-26 19:14:28',
    'EMP-0001',
    '2025-03-26 13:44:28',
    'EMP-0001'
  ),
  (
    7,
    1,
    'iPanel Wall 20cm',
    1,
    '2025-03-26 19:15:14',
    'EMP-0001',
    '2025-03-26 13:45:14',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `colors`
--
CREATE TABLE
  `colors` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `owner_id` int DEFAULT NULL,
    `members` text COLLATE utf8mb4_unicode_ci,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `companies`
--
CREATE TABLE
  `companies` (
    `id` bigint NOT NULL,
    `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `owner_id` int DEFAULT NULL,
    `description` text COLLATE utf8mb4_unicode_ci,
    `logo_url` text COLLATE utf8mb4_unicode_ci,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `companies`
--
INSERT INTO
  `companies` (
    `id`,
    `company_name`,
    `owner_id`,
    `description`,
    `logo_url`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'Idea Industries Limited',
    1,
    'Idea Group of  company',
    'https://www.idea.lk/logo.png',
    1,
    '2025-03-18 18:12:35',
    'EMP-0001',
    '2025-03-26 13:14:42',
    'EMP-0001'
  ),
  (
    2,
    'T',
    1,
    '',
    '',
    1,
    '2025-03-25 06:55:16',
    'EMP-0001',
    '2025-03-25 05:25:16',
    'EMP-0001'
  ),
  (
    3,
    'Test',
    1,
    '',
    '',
    1,
    '2025-03-25 06:55:32',
    'EMP-0001',
    '2025-03-25 05:25:32',
    'EMP-0001'
  ),
  (
    4,
    'Test company ',
    1,
    '',
    '',
    1,
    '2025-03-25 06:55:55',
    'EMP-0001',
    '2025-03-25 05:25:55',
    'EMP-0001'
  ),
  (
    5,
    'H',
    1,
    '',
    '',
    1,
    '2025-03-25 06:59:19',
    'EMP-0001',
    '2025-03-25 05:29:19',
    'EMP-0001'
  ),
  (
    6,
    'Tes6',
    1,
    '',
    '',
    1,
    '2025-03-25 06:59:29',
    'EMP-0001',
    '2025-03-25 05:29:29',
    'EMP-0001'
  ),
  (
    7,
    '2nd Company',
    1,
    '',
    '',
    1,
    '2025-03-25 13:02:08',
    'EMP-0001',
    '2025-03-25 07:32:08',
    'EMP-0001'
  ),
  (
    8,
    'Company 3',
    1,
    '',
    '',
    1,
    '2025-03-25 13:04:49',
    'EMP-0001',
    '2025-03-25 07:34:49',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `currency_types`
--
CREATE TABLE
  `currency_types` (
    `id` bigint NOT NULL,
    `currency_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_types`
--
INSERT INTO
  `currency_types` (
    `id`,
    `currency_type`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'LKR',
    1,
    '2025-03-20 00:57:19',
    'EMP-0001',
    '2025-03-19 13:57:39',
    'EMP-0001'
  ),
  (
    2,
    'USD',
    1,
    '2025-03-20 00:57:19',
    'EMP-0001',
    '2025-03-19 13:57:47',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `departments`
--
CREATE TABLE
  `departments` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `department` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `description` text COLLATE utf8mb4_unicode_ci,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `departments`
--
INSERT INTO
  `departments` (
    `id`,
    `company_id`,
    `department`,
    `description`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    'Management',
    '',
    1,
    '2025-03-24 21:39:11',
    'EMP-0001',
    '2025-03-24 20:18:15',
    'EMP-0001'
  ),
  (
    2,
    1,
    'T',
    '',
    0,
    '2025-03-25 07:03:14',
    'EMP-0001',
    '2025-03-25 05:33:20',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `failed_jobs`
--
CREATE TABLE
  `failed_jobs` (
    `id` bigint UNSIGNED NOT NULL,
    `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `locations`
--
CREATE TABLE
  `locations` (
    `id` bigint NOT NULL,
    `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `company_id` int DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `locations`
--
INSERT INTO
  `locations` (
    `id`,
    `location`,
    `company_id`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'India',
    1,
    0,
    '2025-03-25 06:54:24',
    'EMP-0001',
    '2025-03-25 05:24:29',
    'EMP-0001'
  ),
  (
    2,
    'i-Panel Factory ',
    1,
    1,
    '2025-03-26 18:55:09',
    'EMP-0001',
    '2025-03-26 13:25:09',
    'EMP-0001'
  ),
  (
    3,
    'i-Roof Factory',
    1,
    1,
    '2025-03-26 18:55:30',
    'EMP-0001',
    '2025-03-26 13:25:30',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `machines`
--
CREATE TABLE
  `machines` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `machine_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `machine_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `description` text COLLATE utf8mb4_unicode_ci,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `migrations`
--
CREATE TABLE
  `migrations` (
    `id` int UNSIGNED NOT NULL,
    `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `batch` int NOT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--
INSERT INTO
  `migrations` (`id`, `migration`, `batch`)
VALUES
  (1, '2014_10_12_000000_create_users_table', 1),
  (
    2,
    '2014_10_12_100000_create_password_reset_tokens_table',
    1
  ),
  (
    3,
    '2019_08_19_000000_create_failed_jobs_table',
    1
  ),
  (
    4,
    '2019_12_14_000001_create_personal_access_tokens_table',
    1
  ),
  (5, '2024_05_25_225401_create_sessions_table', 1);

-- --------------------------------------------------------
--
-- Table structure for table `packages`
--
CREATE TABLE
  `packages` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `batch_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `package_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `password_reset_tokens`
--
CREATE TABLE
  `password_reset_tokens` (
    `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `created_at` timestamp NULL DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `permissions`
--
CREATE TABLE
  `permissions` (
    `id` int NOT NULL,
    `permission` varchar(255) NOT NULL,
    `permission_key` varchar(255) NOT NULL,
    `company_id` int NOT NULL,
    `is_active` tinyint (1) DEFAULT '1',
    `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
    `created_by` varchar(255) DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci;

--
-- Dumping data for table `permissions`
--
INSERT INTO
  `permissions` (
    `id`,
    `permission`,
    `permission_key`,
    `company_id`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'Master Data Management',
    'master_data_management',
    1,
    1,
    '2025-03-26 09:43:08',
    'admin',
    '2025-03-26 09:43:08',
    'admin'
  ),
  (
    2,
    'Badge Data Management',
    'badge_data_management',
    1,
    1,
    '2025-03-26 09:43:08',
    'admin',
    '2025-03-26 09:43:08',
    'admin'
  ),
  (
    3,
    'Package Data Management',
    'package_data_management',
    1,
    1,
    '2025-03-26 09:43:08',
    'admin',
    '2025-03-26 09:43:08',
    'admin'
  );

-- --------------------------------------------------------
--
-- Table structure for table `personal_access_tokens`
--
CREATE TABLE
  `personal_access_tokens` (
    `id` bigint UNSIGNED NOT NULL,
    `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `tokenable_id` bigint UNSIGNED NOT NULL,
    `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `abilities` text COLLATE utf8mb4_unicode_ci,
    `last_used_at` timestamp NULL DEFAULT NULL,
    `expires_at` timestamp NULL DEFAULT NULL,
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `products`
--
CREATE TABLE
  `products` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `product_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `product_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `length` double (12, 4) DEFAULT NULL,
    `height` double (12, 4) DEFAULT NULL,
    `width` double (12, 4) DEFAULT NULL,
    `weight` double (12, 4) DEFAULT '0.0000',
    `color_id` int DEFAULT NULL,
    `total_sqft` double (12, 4) DEFAULT NULL,
    `unit_cost` double (8, 2) DEFAULT NULL,
    `sub_units_per_unit` int DEFAULT NULL,
    `location_id` int DEFAULT NULL,
    `unit_id` int DEFAULT NULL,
    `sub_unit_id` int DEFAULT NULL,
    `selling_value` double (8, 2) DEFAULT NULL,
    `total_items` int DEFAULT NULL,
    `product_section_id` int DEFAULT NULL,
    `product_category_id` int DEFAULT NULL,
    `warranty_period` int DEFAULT '0',
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `product_files`
--
CREATE TABLE
  `product_files` (
    `id` bigint NOT NULL,
    `product_id` int DEFAULT NULL,
    `company_id` int DEFAULT NULL,
    `attachment_type` int DEFAULT NULL,
    `file_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `file_path` text COLLATE utf8mb4_unicode_ci,
    `file_size` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `file_extension` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `provinces`
--
CREATE TABLE
  `provinces` (
    `id` bigint NOT NULL,
    `province` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `provinces`
--
INSERT INTO
  `provinces` (
    `id`,
    `province`,
    `is_active`,
    `created_at`,
    `updated_at`
  )
VALUES
  (
    1,
    'Western Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    2,
    'Central Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    3,
    'Southern Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    4,
    'North Western Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    5,
    'Sabaragamuwa Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    6,
    'Eastern Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    7,
    'Uva Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    8,
    'North Central Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  ),
  (
    9,
    'Nothern Province',
    1,
    '2024-06-01 17:55:33',
    '2024-06-01 20:25:35'
  );

-- --------------------------------------------------------
--
-- Table structure for table `roles`
--
CREATE TABLE
  `roles` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `role` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--
INSERT INTO
  `roles` (
    `id`,
    `company_id`,
    `role`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    0,
    'Super Admin',
    1,
    '2025-03-24 21:15:34',
    'EMP-0001',
    '2025-03-24 10:16:07',
    'EMP-0001'
  ),
  (
    2,
    0,
    'Company Owner',
    1,
    '2025-03-24 21:15:34',
    'EMP-0001',
    '2025-03-24 10:16:35',
    'EMP-0001'
  ),
  (
    3,
    1,
    'Test',
    0,
    '2025-03-25 06:56:33',
    'EMP-0001',
    '2025-03-25 05:26:39',
    'EMP-0001'
  ),
  (
    4,
    1,
    'Role 3',
    1,
    '2025-03-25 13:04:18',
    'EMP-0001',
    '2025-03-25 07:34:18',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `role_permissions`
--
CREATE TABLE
  `role_permissions` (
    `id` int NOT NULL,
    `role_id` int NOT NULL,
    `permission_id` int NOT NULL,
    `has_view` tinyint (1) NOT NULL DEFAULT '0',
    `has_edit` tinyint (1) NOT NULL DEFAULT '0',
    `has_delete` tinyint (1) NOT NULL DEFAULT '0',
    `has_add` tinyint (1) NOT NULL DEFAULT '0',
    `company_id` int NOT NULL,
    `is_active` tinyint (1) NOT NULL DEFAULT '1',
    `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
    `created_by` varchar(255) NOT NULL,
    `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) NOT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci;

-- --------------------------------------------------------
--
-- Table structure for table `sections`
--
CREATE TABLE
  `sections` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `section` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `sections`
--
INSERT INTO
  `sections` (
    `id`,
    `company_id`,
    `section`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    'iPanel Factory',
    1,
    '2025-03-26 18:52:42',
    'EMP-0001',
    '2025-03-26 13:23:48',
    'EMP-0001'
  ),
  (
    2,
    1,
    'iRoof Factory',
    1,
    '2025-03-26 18:52:48',
    'EMP-0001',
    '2025-03-26 13:23:55',
    'EMP-0001'
  ),
  (
    3,
    1,
    'Metal Factory ',
    1,
    '2025-03-26 18:52:53',
    'EMP-0001',
    '2025-03-26 13:24:04',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `sessions`
--
CREATE TABLE
  `sessions` (
    `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `user_id` bigint UNSIGNED DEFAULT NULL,
    `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `user_agent` text COLLATE utf8mb4_unicode_ci,
    `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    `last_activity` int NOT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `settings`
--
CREATE TABLE
  `settings` (
    `id` bigint NOT NULL,
    `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `is_active` int NOT NULL DEFAULT '1',
    `created_at` datetime NOT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `stores`
--
CREATE TABLE
  `stores` (
    `id` int NOT NULL AUTO_INCREMENT,
    `company_id` int DEFAULT NULL,
    `province_id` int NOT NULL,
    `area_id` int NOT NULL,
    `store` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `store_address` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `store_number` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `contact_person` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `contact_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `is_active` tinyint (1) DEFAULT '1',
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`) -- Corrected PRIMARY KEY syntax
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `sub_units`
--
CREATE TABLE
  `sub_units` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `unit_id` int DEFAULT NULL,
    `sub_unit_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `sub_units`
--
INSERT INTO
  `sub_units` (
    `id`,
    `company_id`,
    `unit_id`,
    `sub_unit_label`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    1,
    '1',
    0,
    '2025-03-25 06:54:48',
    'EMP-0001',
    '2025-03-25 05:24:53',
    'EMP-0001'
  ),
  (
    2,
    1,
    2,
    'Kg',
    0,
    '2025-03-26 18:50:31',
    'EMP-0001',
    '2025-03-26 13:39:54',
    'EMP-0001'
  ),
  (
    3,
    1,
    2,
    'Box',
    0,
    '2025-03-26 18:50:42',
    'EMP-0001',
    '2025-03-26 13:39:50',
    'EMP-0001'
  ),
  (
    4,
    1,
    2,
    'Sheet',
    0,
    '2025-03-26 18:50:52',
    'EMP-0001',
    '2025-03-26 13:39:47',
    'EMP-0001'
  ),
  (
    5,
    1,
    2,
    'Sqm',
    0,
    '2025-03-26 18:51:04',
    'EMP-0001',
    '2025-03-26 13:39:44',
    'EMP-0001'
  ),
  (
    6,
    1,
    2,
    'Ton',
    0,
    '2025-03-26 18:51:10',
    'EMP-0001',
    '2025-03-26 13:39:38',
    'EMP-0001'
  ),
  (
    7,
    1,
    2,
    'Lt',
    0,
    '2025-03-26 18:51:15',
    'EMP-0001',
    '2025-03-26 13:39:33',
    'EMP-0001'
  ),
  (
    8,
    1,
    2,
    'SQFT',
    0,
    '2025-03-26 18:51:24',
    'EMP-0001',
    '2025-03-26 13:39:30',
    'EMP-0001'
  ),
  (
    9,
    1,
    2,
    'Roll',
    0,
    '2025-03-26 18:51:39',
    'EMP-0001',
    '2025-03-26 13:39:26',
    'EMP-0001'
  ),
  (
    10,
    1,
    1,
    'Sheet',
    1,
    '2025-03-26 19:07:38',
    'EMP-0001',
    '2025-03-26 13:37:38',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `units`
--
CREATE TABLE
  `units` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `unit_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `units`
--
INSERT INTO
  `units` (
    `id`,
    `company_id`,
    `unit_label`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    'Box',
    1,
    '2025-03-25 06:54:43',
    'EMP-0001',
    '2025-03-26 13:20:09',
    'EMP-0001'
  ),
  (
    2,
    1,
    'Sheet',
    0,
    '2025-03-26 18:50:22',
    'EMP-0001',
    '2025-03-26 13:40:00',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `users`
--
CREATE TABLE
  `users` (
    `id` bigint UNSIGNED NOT NULL,
    `role_id` int DEFAULT NULL,
    `company_id` int DEFAULT '1',
    `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `last_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `nic` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `emp_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `email_verified_at` timestamp NULL DEFAULT NULL,
    `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `contact_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `otp_number` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `otp_reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `otp_count` int DEFAULT '0',
    `push_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `os_type` int DEFAULT NULL,
    `status` int DEFAULT '0',
    `department_id` int DEFAULT NULL,
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--
INSERT INTO
  `users` (
    `id`,
    `role_id`,
    `company_id`,
    `first_name`,
    `last_name`,
    `nic`,
    `emp_number`,
    `email_verified_at`,
    `password`,
    `contact_number`,
    `otp_number`,
    `otp_reference`,
    `otp_count`,
    `push_id`,
    `os_type`,
    `status`,
    `department_id`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    2,
    1,
    'Sampath',
    'Mayakaduwa',
    '941024587V',
    'EMP-0001',
    NULL,
    '$2y$10$AmFgBUf85kfufLwypsDJjeeDlZlwA0OX69L7o8b/UMCIXZV0vTxDa',
    '777006055',
    '123456',
    'NzhGnt3ehP22CLce',
    0,
    NULL,
    0,
    1,
    1,
    1,
    '2025-03-19 21:35:04',
    'EMP-0001',
    '2025-03-25 07:31:52',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `user_companies`
--
CREATE TABLE
  `user_companies` (
    `id` bigint NOT NULL,
    `company_id` int DEFAULT NULL,
    `user_id` int DEFAULT NULL,
    `member_type` int DEFAULT '2',
    `is_active` int DEFAULT '1',
    `created_at` datetime DEFAULT NULL,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `user_companies`
--
INSERT INTO
  `user_companies` (
    `id`,
    `company_id`,
    `user_id`,
    `member_type`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    1,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:46:53',
    'EMP-0001'
  ),
  (
    2,
    2,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    3,
    3,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    4,
    4,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    5,
    5,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    6,
    6,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    7,
    7,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  ),
  (
    8,
    8,
    1,
    1,
    1,
    '2025-03-27 08:16:21',
    'EMP-0001',
    '2025-03-27 02:47:57',
    'EMP-0001'
  );

-- --------------------------------------------------------
--
-- Table structure for table `vehicles`
--
CREATE TABLE
  `vehicles` (
    `id` int NOT NULL,
    `company_id` int DEFAULT NULL,
    `registration_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `vehicle_type_id` int NOT NULL,
    `is_active` tinyint (1) DEFAULT '1',
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

-- --------------------------------------------------------
--
-- Table structure for table `vehicle_types`
--
CREATE TABLE
  `vehicle_types` (
    `id` int NOT NULL,
    `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `is_active` tinyint (1) DEFAULT '1',
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `created_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `updated_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
  ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

--
-- Dumping data for table `vehicle_types`
--
INSERT INTO
  `vehicle_types` (
    `id`,
    `type`,
    `is_active`,
    `created_at`,
    `created_by`,
    `updated_at`,
    `updated_by`
  )
VALUES
  (
    1,
    'Car',
    1,
    '2025-03-25 00:03:30',
    'EMP-0001',
    '2025-03-24 14:34:59',
    'EMP-0001'
  ),
  (
    2,
    'Van',
    1,
    '2025-03-25 00:03:30',
    'EMP-0001',
    '2025-03-24 14:35:13',
    'EMP-0001'
  ),
  (
    3,
    'Bus',
    1,
    '2025-03-25 00:03:30',
    'EMP-0001',
    '2025-03-24 14:35:44',
    'EMP-0001'
  );

--
-- Indexes for dumped tables
--
--
-- Indexes for table `accounts`
--
ALTER TABLE `accounts` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `account_types`
--
ALTER TABLE `account_types` ADD PRIMARY KEY (`id`);

ALTER TABLE `expense_categories` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `areas`
--
ALTER TABLE `areas` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `batches`
--
ALTER TABLE `batches` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `colors`
--
ALTER TABLE `colors` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `companies`
--
ALTER TABLE `companies` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `currency_types`
--
ALTER TABLE `currency_types` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `departments`
--
ALTER TABLE `departments` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs` ADD PRIMARY KEY (`id`),
ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `locations`
--
ALTER TABLE `locations` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `machines`
--
ALTER TABLE `machines` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `packages`
--
ALTER TABLE `packages` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens` ADD PRIMARY KEY (`email`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions` ADD PRIMARY KEY (`id`),
ADD UNIQUE KEY `permission_key` (`permission_key`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens` ADD PRIMARY KEY (`id`),
ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`, `tokenable_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `product_files`
--
ALTER TABLE `product_files` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `provinces`
--
ALTER TABLE `provinces` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `role_permissions`
--
ALTER TABLE `role_permissions` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sections`
--
ALTER TABLE `sections` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions` ADD PRIMARY KEY (`id`),
ADD KEY `sessions_user_id_index` (`user_id`),
ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `stores`
--
ALTER TABLE `stores` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sub_units`
--
ALTER TABLE `sub_units` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `units`
--
ALTER TABLE `units` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `user_companies`
--
ALTER TABLE `user_companies` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `vehicles`
--
ALTER TABLE `vehicles` ADD PRIMARY KEY (`id`);

--
-- Indexes for table `vehicle_types`
--
ALTER TABLE `vehicle_types` ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--
--
-- AUTO_INCREMENT for table `accounts`
--
ALTER TABLE `accounts` MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_types`
--
ALTER TABLE `account_types` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 3;

--
-- AUTO_INCREMENT for table `areas`
--
ALTER TABLE `areas` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 3;

--
-- AUTO_INCREMENT for table `batches`
--
ALTER TABLE `batches` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 8;

--
-- AUTO_INCREMENT for table `colors`
--
ALTER TABLE `colors` MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `companies`
--
ALTER TABLE `companies` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 9;

--
-- AUTO_INCREMENT for table `currency_types`
--
ALTER TABLE `currency_types` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 3;

--
-- AUTO_INCREMENT for table `departments`
--
ALTER TABLE `departments` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 3;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `locations`
--
ALTER TABLE `locations` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 4;

--
-- AUTO_INCREMENT for table `machines`
--
ALTER TABLE `machines` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations` MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 6;

--
-- AUTO_INCREMENT for table `packages`
--
ALTER TABLE `packages` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions` MODIFY `id` int NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 4;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_files`
--
ALTER TABLE `product_files` MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `provinces`
--
ALTER TABLE `provinces` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 10;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles` MODIFY `id` int NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 5;

--
-- AUTO_INCREMENT for table `role_permissions`
--
ALTER TABLE `role_permissions` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sections`
--
ALTER TABLE `sections` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 4;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 2;

--
-- AUTO_INCREMENT for table `stores`
--
ALTER TABLE `stores` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sub_units`
--
ALTER TABLE `sub_units` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 11;

--
-- AUTO_INCREMENT for table `units`
--
ALTER TABLE `units` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 3;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 2;

--
-- AUTO_INCREMENT for table `user_companies`
--
ALTER TABLE `user_companies` MODIFY `id` bigint NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 10;

--
-- AUTO_INCREMENT for table `vehicles`
--
ALTER TABLE `vehicles` MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `vehicle_types`
--
ALTER TABLE `vehicle_types` MODIFY `id` int NOT NULL AUTO_INCREMENT,
AUTO_INCREMENT = 4;

COMMIT;