<?php

namespace App\Traits;

use App\Services\OperationalDataLogger;

trait LogsOperationalData
{
    public static function bootLogsOperationalData()
    {
        static::created(function ($model) {
            app(OperationalDataLogger::class)->log(
                'C',
                class_basename($model),
                'Created ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });

        static::updated(function ($model) {
            app(OperationalDataLogger::class)->log(
                'U',
                class_basename($model),
                'Updated ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->updated_by ?? $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });

        static::deleted(function ($model) {
            app(OperationalDataLogger::class)->log(
                'D',
                class_basename($model),
                'Deleted ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->updated_by ?? $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });
    }
}
