<?php

namespace App\Traits;

use App\Services\MasterDataLogger;

trait LogsMasterData
{
    public static function bootLogsMasterData()
    {
        static::created(function ($model) {
            app(MasterDataLogger::class)->log(
                'C', // Create
                class_basename($model),
                'Created ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });

        static::updated(function ($model) {
            app(MasterDataLogger::class)->log(
                'U', // Update
                class_basename($model),
                'Updated ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->updated_by ?? $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });

        static::deleted(function ($model) {
            app(MasterDataLogger::class)->log(
                'D', // Delete
                class_basename($model),
                'Deleted ' . class_basename($model) . ' (ID: ' . $model->id . ')',
                $model->updated_by ?? $model->created_by ?? 'system',
                $model->company_id ?? null
            );
        });
    }
}
