<?php

namespace App\Services;

use App\Models\OperationalDataLog;

class OperationalDataLogger
{
    /**
     * Log an operational (high-priority) action.
     */
    public function log(
        string $actionType,
        string $module,
        string $description,
        string $doneBy,
        int $companyId = null,
        ?array $payload = null
    ): void {
        OperationalDataLog::create([
            'action_type' => strtoupper($actionType),
            'module'      => $module,
            'description' => $description,
            'date'        => now(),
            'done_by'     => $doneBy,
            'company_id'  => $companyId,
            'payload'     => $payload ?? request()->all(),
        ]);
    }
}
