<?php

namespace App\Services;

use App\Models\MasterDataLog;

class MasterDataLogger
{
    public function log(
        string $actionType,
        string $module,
        string $description,
        string $doneBy,
        int $companyId = null,
        ?array $payload = null
    ): void {
        MasterDataLog::create([
            'action_type' => strtoupper($actionType),
            'module'      => $module,
            'description' => $description,
            'date'        => now(),
            'done_by'     => $doneBy,
            'company_id'  => $companyId,
            'payload'     => $payload ?? request()->all(),
        ]);
    }
}
