<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class BrevoMailServiceProvider extends Mailable
{
    use Queueable, SerializesModels;

    public $details;

    /**
     * Create a new message instance.
     *
     * @param array $details
     */
    public function __construct($details)
    {
        $this->details = $details;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // Default fallback view
        $view = 'email.brevo_template';

        // Determine email view based on type
        if (isset($this->details['type'])) {
            switch ($this->details['type']) {
                case 'otp':
                    $view = 'email.otp_verification_email_template';
                    break;
                case 'welcome':
                    $view = 'email.welcome_email_template';
                    break;
                case 'password_reset':
                    $view = 'email.password_reset_email_template';
                    break;
                case 'sales_order_invoice':
                    $view = 'email.sales_order_email_template';
                    break;
                case 'sales_dispatch_note':
                    $view = 'email.sales_dispatch_email_template';
                    break;
                case 'sales_warranty_note':
                    $view = 'email.sales_warranty_email_template';
                    break;
                case 'delivery_note':
                    $view = 'email.sales_delivery_email_template';
                    Log::info('Using delivery note email template', ['details' => $this->details]);
                    break;
            }
        }

        $mail = $this->subject($this->details['subject'] ?? 'Notification from iNote')
            ->view($view)
            ->with($this->details);

        // Attach PDF if exists
        if (!empty($this->details['pdf_path']) && file_exists($this->details['pdf_path'])) {
            $mail->attach($this->details['pdf_path'], [
                'as' => basename($this->details['pdf_path']),
                'mime' => 'application/pdf',
            ]);
        }
        $mail->from('info@iNote.lk', 'iNote');

        return $mail;
    }
}
