<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class LogHttpRequests
{
    public function handle(Request $request, Closure $next)
    {
        // Extract custom headers
        $build_number = $request->header('Build-Number') ?? null;
        $app_type     = $request->header('App-Type') ?? null;
        $os_type      = $request->header('OS-Type') ?? null;

        // Log the request
        Log::channel('httplog')->info('HTTP Request', [
            'timestamp'     => now()->toDateTimeString(),
            'url'           => $request->fullUrl(),
            'method'        => $request->method(),
            'ip'            => $request->ip(),
            'user'          => auth()->user()->emp_number ?? 'guest',
            'payload'       => $request->all(),
            'build_number'  => $request->header('Build-Number'),
            'app_type'      => $request->header('App-Type'),
            'os_type'       => $request->header('OS-Type'),
        ]);
        

        return $next($request);
    }
}
