<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class JwtMiddleware extends BaseMiddleware
{
    private function fail(string $message, int $status = 401)
    {
        return response()->json([
            'success' => false,
            'message' => $message,
            'data'    => null,
        ], $status);
    }

    public function handle(Request $request, Closure $next)
    {
        try {
            $user = JWTAuth::parseToken()->authenticate();

            if (!$user) {
                // user not found in DB (token valid but user deleted)
                return $this->fail('User not found.', 401);
            }

            // Optional: make sure request has user resolver
            // auth()->setUser($user);

            return $next($request);

        } catch (TokenInvalidException $e) {
            return $this->fail('Token is invalid.', 401);

        } catch (TokenExpiredException $e) {
            // If you want frontend to refresh token, use 401 but with special message/code
            return $this->fail('Token is expired.', 401);

        } catch (Throwable $e) {
            // Token missing or other errors
            return $this->fail('Authorization token not found.', 401);
        }
    }
}
